package com.ejie.ab18a.dao;

import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridManagerJerarquia;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.JerarquiaDto;
import com.ejie.x38.dto.TableRowDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab18a.model.Ab18aResultadoValidacion;

;

/**
 * Ab18aResultadoValidacionDaoImpl generated by XXXX, 03-feb-2017 12:02:31.
 * 
 * @author XXXX
 */

@Repository
@Transactional
public class Ab18aResultadoValidacionDaoImpl implements
		Ab18aResultadoValidacionDao {
	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<Ab18aResultadoValidacion> rwMap = new RowMapper<Ab18aResultadoValidacion>() {
		public Ab18aResultadoValidacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Ab18aResultadoValidacion(
					resultSet.getLong("T09IDVALIDACION"),
					resultSet.getLong("T10IDTIPOVALIDACION"),
					resultSet.getString("T09NOMBREVALID"),
					resultSet.getString("T09SUPERA"),
					resultSet.getString("T09SEVERIDAD"),
					resultSet.getString("T09MENSAJE"),
					resultSet.getString("T09DETALLES"),
					resultSet.getLong("T01IDPETICIONENVIO"));
		}
	};

	private RowMapper<Ab18aResultadoValidacion> rwMapPK = new RowMapper<Ab18aResultadoValidacion>() {
		public Ab18aResultadoValidacion mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new Ab18aResultadoValidacion(
					resultSet.getLong("T09IDVALIDACION"));
		}
	};

	/**
	 * Rowmapper para Jerarquía
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	private RowMapper<JerarquiaDto<Ab18aResultadoValidacion>> rwMapJerarquia = new RowMapper<JerarquiaDto<Ab18aResultadoValidacion>>() {
		public JerarquiaDto<Ab18aResultadoValidacion> mapRow(
				ResultSet resultSet, int rowNum) throws SQLException {

			Ab18aResultadoValidacion resultadoValidacion = new Ab18aResultadoValidacion(
					resultSet.getLong("T09IDVALIDACION"),
					resultSet.getLong("T10IDTIPOVALIDACION"),
					resultSet.getString("T09NOMBREVALID"),
					resultSet.getString("T09SUPERA"),
					resultSet.getString("T09SEVERIDAD"),
					resultSet.getString("T09MENSAJE"),
					resultSet.getString("T09DETALLES"),
					resultSet.getLong("T01IDPETICIONENVIO"));

			JerarquiaDto<Ab18aResultadoValidacion> jerarquia = new JerarquiaDto<Ab18aResultadoValidacion>();
			jerarquia.setModel(resultadoValidacion);
			jerarquia.setLevel(resultSet.getBigDecimal("LEVEL").intValue());
			jerarquia.setParentNodes(resultSet.getString("PARENTNODES"));
			jerarquia.setIsLeaf(Boolean.parseBoolean(resultSet
					.getString("ISLEAF")));
			jerarquia.setFilter(Boolean.parseBoolean(resultSet
					.getString("FILTER")));
			return jerarquia;
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * @param dataSource
	 *            DataSource
	 * @return
	 */
	@Resource
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab18a09s00 table.
	 * 
	 * @param resultadoValidacion
	 *            Ab18aResultadoValidacion
	 * @return Ab18aResultadoValidacion
	 */
	public Ab18aResultadoValidacion add(
			Ab18aResultadoValidacion resultadoValidacion) {
		String query = "INSERT INTO AB18A09S00 (T09_ID_VALIDACION, T01_ID_PETICION_ENVIO, T10_ID_TIPO_VALIDACION, T09_NOMBRE_VALID, T09_SUPERA, T09_SEVERIDAD, T09_MENSAJE, T09_DETALLES) VALUES (?,?,?,?,?,?,?,?)";

		this.jdbcTemplate.update(query,
				resultadoValidacion.getT09IdValidacion(),
				resultadoValidacion.getT01IdPeticionEnvio(),
				resultadoValidacion.getT10IdTipoValidacion(),
				resultadoValidacion.getT09NombreValid(),
				resultadoValidacion.getT09Supera(),
				resultadoValidacion.getT09Severidad(),
				resultadoValidacion.getT09Mensaje(),
				resultadoValidacion.getT09Detalles());
		return resultadoValidacion;
	}

	/**
	 * Updates a single row in the Ab18a09s00 table.
	 * 
	 * @param resultadoValidacion
	 *            Ab18aResultadoValidacion
	 * @return Ab18aResultadoValidacion
	 */
	public Ab18aResultadoValidacion update(
			Ab18aResultadoValidacion resultadoValidacion) {
		String query = "UPDATE AB18A09S00 SET T01_ID_PETICION_ENVIO=?, T10_ID_TIPO_VALIDACION=?, T09_NOMBRE_VALID=?, T09_SUPERA=?, T09_SEVERIDAD=?, T09_MENSAJE=?, T09_DETALLES=? WHERE T09_ID_VALIDACION=?";

		this.jdbcTemplate.update(query,
				resultadoValidacion.getT01IdPeticionEnvio(),
				resultadoValidacion.getT10IdTipoValidacion(),
				resultadoValidacion.getT09NombreValid(),
				resultadoValidacion.getT09Supera(),
				resultadoValidacion.getT09Severidad(),
				resultadoValidacion.getT09Mensaje(),
				resultadoValidacion.getT09Detalles(),
				resultadoValidacion.getT09IdValidacion());
		return resultadoValidacion;
	}

	/**
	 * Finds a single row in the Ab18a09s00 table.
	 * 
	 * @param resultadoValidacion
	 *            Ab18aResultadoValidacion
	 * @return Ab18aResultadoValidacion
	 */
	@Transactional(readOnly = true)
	public Ab18aResultadoValidacion find(
			Ab18aResultadoValidacion resultadoValidacion) {
		String query = "SELECT t1.T09_ID_VALIDACAb18aResultadoValidacionALIDACION, t1.T10_ID_TIPO_VALIDACION T10IDTIPOVALIDACION, t1.T09_NOMBRE_VALID T09NOMBREVALID, t1.T09_SUPERA T09SUPERA, t1.T09_SEVERIDAD T09SEVERIDAD, t1.T09_MENSAJE T09MENSAJE, t1.T09_DETALLES T09DETALLES, t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO, t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA, t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP, t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML, t2.T01_ID_PODER AB18A01S00T01IDPODER, t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP, t2.T01_ID_ORGANO AB18A01S00T01IDORGANO, t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM, t2.T01_ID_MESA AB18A01S00T01IDMESA, t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO, t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS, t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR, t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM, t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE, t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA, t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO, t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN, t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO, t2.T07_ID_TICKET AB18A01S00T07IDTICKET, t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION, t2.T11_ID_ESTADO AB18A01S00T11IDESTADO FROM AB18A09S00 t1 , AB18A01S00 t2  WHERE t1.T09_ID_VALIDACION = ?   AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+)";

		List<Ab18aResultadoValidacion> resultadoValidacionList = this.jdbcTemplate
				.query(query, this.rwMap,
						resultadoValidacion.getT09IdValidacion());
		return (Ab18aResultadoValidacion) DataAccessUtils
				.uniqueResult(resultadoValidacionList);
	}

	/**
	 * Removes a single row in the Ab18a09s00 table.
	 * 
	 * @param resultadoValidacion
	 *            Ab18aResultadoValidacion
	 * @return
	 */
	public void remove(Ab18aResultadoValidacion resultadoValidacion) {
		String query = "DELETE FROM AB18A09S00 WHERE T09_ID_VALIDACION=?";
		this.jdbcTemplate.update(query,
				resultadoValidacion.getT09IdValidacion());
	}

	/**
	 * Finds a list of rows in the Ab18a09s00 table.
	 * 
	 * @param resultadoValidacion
	 *            Ab18aResultadoValidacion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<Ab18aResultadoValidacion>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aResultadoValidacion> findAll(
			Ab18aResultadoValidacion resultadoValidacion,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T09_ID_VALIDACION T09IDVALIDACION,t1.T10_ID_TIPO_VALIDACION T10IDTIPOVALIDACION,t1.T09_NOMBRE_VALID T09NOMBREVALID,t1.T09_SUPERA T09SUPERA,t1.T09_SEVERIDAD T09SEVERIDAD,t1.T09_MENSAJE T09MENSAJE,t1.T09_DETALLES T09DETALLES,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		query.append("FROM AB18A09S00 t1 ,AB18A01S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(resultadoValidacion);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aResultadoValidacion>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab18a09s00 table using like.
	 * 
	 * @param resultadoValidacion
	 *            Ab18aResultadoValidacion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<Ab18aResultadoValidacion>
	 */
	@Transactional(readOnly = true)
	public List<Ab18aResultadoValidacion> findAllLike(
			Ab18aResultadoValidacion resultadoValidacion,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT  t1.T09_ID_VALIDACION T09IDVALIDACION,t1.T10_ID_TIPO_VALIDACION T10IDTIPOVALIDACION,t1.T09_NOMBRE_VALID T09NOMBREVALID,t1.T09_SUPERA T09SUPERA,t1.T09_SEVERIDAD T09SEVERIDAD,t1.T09_MENSAJE T09MENSAJE,t1.T09_DETALLES T09DETALLES,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		query.append("FROM AB18A09S00 t1 ,AB18A01S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(resultadoValidacion,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<Ab18aResultadoValidacion>) this.jdbcTemplate.query(
				query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab18a09s00 table.
	 * 
	 * @param resultadoValidacion
	 *            Ab18aResultadoValidacion
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(Ab18aResultadoValidacion resultadoValidacion) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB18A09S00 t1 , AB18A01S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(resultadoValidacion);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab18a09s00 table using like.
	 * 
	 * @param resultadoValidacion
	 *            Ab18aResultadoValidacion
	 * @param startsWith
	 *            Boolean
	 * @return Long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(Ab18aResultadoValidacion resultadoValidacion,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB18A09S00 t1 ,AB18A01S00 t2 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(resultadoValidacion,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab18a09s00 selected for rup_table
	 * 
	 * @param resultadoValidacion
	 *            Ab18aResultadoValidacion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18aResultadoValidacion>>
	 */
	@Override
	public List<TableRowDto<Ab18aResultadoValidacion>> reorderSelection(
			Ab18aResultadoValidacion resultadoValidacion,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T09_ID_VALIDACION T09IDVALIDACION,t1.T10_ID_TIPO_VALIDACION T10IDTIPOVALIDACION,t1.T09_NOMBRE_VALID T09NOMBREVALID,t1.T09_SUPERA T09SUPERA,t1.T09_SEVERIDAD T09SEVERIDAD,t1.T09_MENSAJE T09MENSAJE,t1.T09_DETALLES T09DETALLES,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		// FROM
		query.append("FROM AB18A09S00 t1 ,AB18A01S00 t2 ");
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(resultadoValidacion,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, Ab18aResultadoValidacion.class,
				filterParamList, "T09_ID_VALIDACION");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Ab18aResultadoValidacion>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Search method for rup_table
	 * 
	 * @param filterParams
	 *            Ab18aResultadoValidacion
	 * @param searchParams
	 *            Ab18aResultadoValidacion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 * @return List<TableRowDto<Ab18aResultadoValidacion>>
	 */
	@Override
	public List<TableRowDto<Ab18aResultadoValidacion>> search(
			Ab18aResultadoValidacion filterParams,
			Ab18aResultadoValidacion searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T09_ID_VALIDACION T09IDVALIDACION,t1.T10_ID_TIPO_VALIDACION T10IDTIPOVALIDACION,t1.T09_NOMBRE_VALID T09NOMBREVALID,t1.T09_SUPERA T09SUPERA,t1.T09_SEVERIDAD T09SEVERIDAD,t1.T09_MENSAJE T09MENSAJE,t1.T09_DETALLES T09DETALLES,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		// FROM
		query.append("FROM AB18A09S00 t1 ,AB18A01S00 t2 ");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(
				" WHERE 1=1 AND t1.T01_ID_PETICION_ENVIO= t2.T01_ID_PETICION_ENVIO(+) ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings("unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(
				searchParams, startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings("unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, Ab18aResultadoValidacion.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"T09_ID_VALIDACION");

		return this.jdbcTemplate.query(sbReorderSelectionSQL.toString(),
				new RowNumResultSetExtractor<Ab18aResultadoValidacion>(
						this.rwMapPK, jqGridRequestDto), filterParamList
						.toArray());
	}

	/**
	 * Remove multiple method for rup_table
	 * 
	 * @param filterab18a09s00
	 *            Ab18aResultadoValidacion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @param startsWith
	 *            Boolean
	 */
	@Override
	public void removeMultiple(Ab18aResultadoValidacion filterab18a09s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		// SELECT
		/** TODO: select por clave */
		StringBuilder query = new StringBuilder(
				"SELECT t1.T09_ID_VALIDACION T09IDVALIDACION,t1.T10_ID_TIPO_VALIDACION T10IDTIPOVALIDACION,t1.T09_NOMBRE_VALID T09NOMBREVALID,t1.T09_SUPERA T09SUPERA,t1.T09_SEVERIDAD T09SEVERIDAD,t1.T09_MENSAJE T09MENSAJE,t1.T09_DETALLES T09DETALLES,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		// FROM
		query.append("FROM AB18A09S00 t1 ,AB18A01S00 t2 ");

		// WHERE
		Map<String, Object> mapaWhere = this.getWhereLikeMap(filterab18a09s00,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		@SuppressWarnings("unchecked")
		List<Object> params = (List<Object>) mapaWhere.get("params");

		StringBuilder sbRemoveMultipleSQL = JQGridManager
				.getRemoveMultipleQuery(jqGridRequestDto,
						Ab18aResultadoValidacion.class, query, params,
						"T09_ID_VALIDACION");
		this.jdbcTemplate.update(sbRemoveMultipleSQL.toString(),
				params.toArray());
	}

	/**
	 * Filter in the hierarchical Ab18a09s00 table.
	 * 
	 * @param filterAb18aResultadoValidacion
	 *            Ab18aResultadoValidacion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<JerarquiaDto<Ab18aResultadoValidacion>>
	 */
	@Override
	public List<JerarquiaDto<Ab18aResultadoValidacion>> findAllLikeJerarquia(
			Ab18aResultadoValidacion filterAb18aResultadoValidacion,
			JQGridRequestDto jqGridRequestDto) {
		// SELECT
		StringBuilder query = new StringBuilder(
				"SELECT t1.T09_ID_VALIDACION T09IDVALIDACION,t1.T10_ID_TIPO_VALIDACION T10IDTIPOVALIDACION,t1.T09_NOMBRE_VALID T09NOMBREVALID,t1.T09_SUPERA T09SUPERA,t1.T09_SEVERIDAD T09SEVERIDAD,t1.T09_MENSAJE T09MENSAJE,t1.T09_DETALLES T09DETALLES,t2.T01_ID_PETICION_ENVIO AB18A01S00T01IDPETICIONENVIO,t2.T01_FECHA_ALTA AB18A01S00T01FECHAALTA,t2.T01_ANUNCIO_ZIP AB18A01S00T01ANUNCIOZIP,t2.T01_ANUNCIO_XML AB18A01S00T01ANUNCIOXML,t2.T01_ID_PODER AB18A01S00T01IDPODER,t2.T01_ID_ENTIDAD_IMP AB18A01S00T01IDENTIDADIMP,t2.T01_ID_ORGANO AB18A01S00T01IDORGANO,t2.T01_ID_ENTIDAD_TRAM AB18A01S00T01IDENTIDADTRAM,t2.T01_ID_MESA AB18A01S00T01IDMESA,t2.T01_FECHA_PROGR_ENVIO AB18A01S00T01FECHAPROGRENVIO,t2.T01_NUM_INTENTOS AB18A01S00T01NUMINTENTOS,t2.T01_DATOS_ERROR AB18A01S00T01DATOSERROR,t2.T01_ESTADO_TRAM AB18A01S00T01ESTADOTRAM,t2.T01_COD_EXPEDIENTE AB18A01S00T01CODEXPEDIENTE,t2.T01_RESULT_VALID_LOGICA AB18A01S00T01RESULTVALIDLOGICA,t2.T01_ANUNCIO_XML_CONVERTIDO AB18A01S00T01ANUNCIOXMLCONVERTIDO,t2.T06_ID_BOLETIN AB18A01S00T06IDBOLETIN,t2.T02_ID_TIPO_ENVIO AB18A01S00T02IDTIPOENVIO,t2.T07_ID_TICKET AB18A01S00T07IDTICKET,t2.T03_ID_APLICACION AB18A01S00T03IDAPLICACION,t2.T11_ID_ESTADO AB18A01S00T11IDESTADO ");
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A09S00 t1 ,AB18A01S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A09S00");
		from.add("AB18A01S00");
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				filterAb18aResultadoValidacion, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
				mapaWhere, "T09_ID_VALIDACION", "ID_PADRE", "NOMBRE", from,
				from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// query = JQGridManagerJerarquia.getQuery(jqGridRequestDto, query,
		// mapaWhere, "ID", "ID_PADRE", "NOMBRE", from, from_alias, joins,
		// businessFilters, businessParams);

		// PAGINACION
		if (jqGridRequestDto != null) {
			query = JQGridManagerJerarquia.getPaginationQuery(jqGridRequestDto,
					query);
		}

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.query(query.toString(), this.rwMapJerarquia,
				params.toArray());
	}

	/**
	 * Count rows in hierarchy
	 * 
	 * @param filterAb18aResultadoValidacion
	 *            Ab18aResultadoValidacion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return Long
	 */
	@Override
	public Long findAllLikeCountJerarquia(
			Ab18aResultadoValidacion filterAb18aResultadoValidacion,
			JQGridRequestDto jqGridRequestDto) {
		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A09S00 t1 ,AB18A01S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A09S00");
		from.add("AB18A01S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				filterAb18aResultadoValidacion, false);

		// JERARQUIA
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryCount(
				jqGridRequestDto, mapaWhere, "T09_ID_VALIDACION", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryCount(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");
		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Find dependent hierarchical rows
	 * 
	 * @param filterAb18aResultadoValidacion
	 *            Ab18aResultadoValidacion
	 * @param jqGridRequestDto
	 *            JQGridRequestDto
	 * @return List<TableRowDto<Ab18aResultadoValidacion>>
	 */
	@Override
	public List<TableRowDto<Ab18aResultadoValidacion>> findAllChild(
			Ab18aResultadoValidacion filterAb18aResultadoValidacion,
			JQGridRequestDto jqGridRequestDto) {

		// FROM
		// StringBuilder from = new
		// StringBuilder("FROM AB18A09S00 t1 ,AB18A01S00 t2 ");
		List<String> from = new ArrayList<String>();
		from.add("AB18A09S00");
		from.add("AB18A01S00");

		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");
		from_alias.add(" t2 ");

		// JOINS TABLAS
		/*
		 * Ejemplo de como indicar joins entre las tablas de la query
		 */
		/*
		 * StringBuilder joins = new StringBuilder("");
		 * joins.append("AND T1.ID=T2.ID_T1");
		 */

		// CONDICIONES (negocio)
		/*
		 * Ejemplo de como incluir condiciones de negocio en la consulta de la
		 * jerarquía
		 */
		/*
		 * StringBuilder businessFilters = new StringBuilder(); List<Object>
		 * businessParams = new ArrayList<Object>();
		 * businessFilters.append("   AND t1.XXXX = ?  ");
		 * businessParams.add("1");
		 */

		// FILTRO
		Map<String, ?> mapaWhere = this.getWhereLikeMap(
				filterAb18aResultadoValidacion, false);

		// MULTISELECCION
		// Especificar la columna padre correspondiente en lugar de la generada
		// por defecto (ID_PADRE)
		StringBuilder query = JQGridManagerJerarquia.getQueryChildren(
				jqGridRequestDto, mapaWhere, "T09_ID_VALIDACION", "ID_PADRE",
				from, from_alias);

		/*
		 * Ejemplo de llamada en caso de indicar joins entre tablas y
		 * condiciones de negocio
		 */
		// StringBuilder query =
		// JQGridManagerJerarquia.getQueryChildren(jqGridRequestDto, mapaWhere,
		// "ID", "ID_PADRE", from, from_alias, joins, businessFilters,
		// businessParams);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.query(query.toString(),
				new RowNumResultSetExtractor<Ab18aResultadoValidacion>(
						this.rwMapPK, "T09_ID_VALIDACION"), params.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a09s00 entity
	 * 
	 * @param resultadoValidacion
	 *            Ab18aResultadoValidacion Bean with the criteria values to
	 *            filter by.
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, ?> getWhereMap(
			Ab18aResultadoValidacion resultadoValidacion) {

		StringBuilder where = new StringBuilder(
				Ab18aResultadoValidacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (resultadoValidacion != null
				&& resultadoValidacion.getT09IdValidacion() != null) {
			where.append(" AND t1.T09_ID_VALIDACION = ?");
			params.add(resultadoValidacion.getT09IdValidacion());
		}
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01IdPeticionEnvio() !=
		// null) {
		// where.append(" AND t2.T01_ID_PETICION_ENVIO = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01IdPeticionEnvio());
		// }
		// if (resultadoValidacion != null
		// && resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a06s00() != null
		// &&
		// resultadoValidacion.getAb18a01s00().getAb18a06s00().getT06IdBoletin()
		// !=
		// null) {
		// where.append(" AND t2.T06_ID_BOLETIN = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getAb18a06s00()
		// .getT06IdBoletin());
		// }
		// if (resultadoValidacion != null
		// && resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a02s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a02s00()
		// .getT02IdTipoEnvio() != null) {
		// where.append(" AND t2.T02_ID_TIPO_ENVIO = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getAb18a02s00()
		// .getT02IdTipoEnvio());
		// }
		// if (resultadoValidacion != null
		// && resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a07s00() != null
		// &&
		// resultadoValidacion.getAb18a01s00().getAb18a07s00().getT07IdTicket()
		// !=
		// null) {
		// where.append(" AND t2.T07_ID_TICKET = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getAb18a07s00()
		// .getT07IdTicket());
		// }
		// if (resultadoValidacion != null
		// && resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a03s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a03s00()
		// .getT03IdAplicacion() != null) {
		// where.append(" AND t2.T03_ID_APLICACION = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getAb18a03s00()
		// .getT03IdAplicacion());
		// }
		// if (resultadoValidacion != null
		// && resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a11s00() != null
		// &&
		// resultadoValidacion.getAb18a01s00().getAb18a11s00().getT11IdEstado()
		// !=
		// null) {
		// where.append(" AND t2.T11_ID_ESTADO = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getAb18a11s00()
		// .getT11IdEstado());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01FechaAlta() != null) {
		// where.append(" AND t2.T01_FECHA_ALTA = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01FechaAlta());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01IdPoder() != null) {
		// where.append(" AND t2.T01_ID_PODER = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01IdPoder());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01IdEntidadImp() != null)
		// {
		// where.append(" AND t2.T01_ID_ENTIDAD_IMP = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01IdEntidadImp());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01IdOrgano() != null) {
		// where.append(" AND t2.T01_ID_ORGANO = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01IdOrgano());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01IdEntidadTram() != null)
		// {
		// where.append(" AND t2.T01_ID_ENTIDAD_TRAM = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01IdEntidadTram());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01IdMesa() != null) {
		// where.append(" AND t2.T01_ID_MESA = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01IdMesa());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01FechaProgrEnvio() !=
		// null) {
		// where.append(" AND t2.T01_FECHA_PROGR_ENVIO = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01FechaProgrEnvio());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01NumIntentos() != null) {
		// where.append(" AND t2.T01_NUM_INTENTOS = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01NumIntentos());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01DatosError() != null) {
		// where.append(" AND t2.T01_DATOS_ERROR = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01DatosError());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01EstadoTram() != null) {
		// where.append(" AND t2.T01_ESTADO_TRAM = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01EstadoTram());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01CodExpediente() != null)
		// {
		// where.append(" AND t2.T01_COD_EXPEDIENTE = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01CodExpediente());
		// }
		// if (resultadoValidacion != null
		// && resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a14s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a14s00()
		// .getT01IdPeticionEnvio() != null) {
		// where.append(" AND t2.T01_ID_PETICION_ENVIO = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getAb18a14s00()
		// .getT01IdPeticionEnvio());
		// }
		if (resultadoValidacion != null
				&& resultadoValidacion.getT10IdTipoValidacion() != null) {
			where.append(" AND t1.T10_ID_TIPO_VALIDACION = ?");
			params.add(resultadoValidacion.getT10IdTipoValidacion());
		}
		if (resultadoValidacion != null
				&& resultadoValidacion.getT09NombreValid() != null) {
			where.append(" AND t1.T09_NOMBRE_VALID = ?");
			params.add(resultadoValidacion.getT09NombreValid());
		}
		if (resultadoValidacion != null
				&& resultadoValidacion.getT09Supera() != null) {
			where.append(" AND t1.T09_SUPERA = ?");
			params.add(resultadoValidacion.getT09Supera());
		}
		if (resultadoValidacion != null
				&& resultadoValidacion.getT09Severidad() != null) {
			where.append(" AND t1.T09_SEVERIDAD = ?");
			params.add(resultadoValidacion.getT09Severidad());
		}
		if (resultadoValidacion != null
				&& resultadoValidacion.getT09Mensaje() != null) {
			where.append(" AND t1.T09_MENSAJE = ?");
			params.add(resultadoValidacion.getT09Mensaje());
		}
		if (resultadoValidacion != null
				&& resultadoValidacion.getT09Detalles() != null) {
			where.append(" AND t1.T09_DETALLES = ?");
			params.add(resultadoValidacion.getT09Detalles());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab18a09s00 entity
	 * 
	 * @param resultadoValidacion
	 *            Ab18aResultadoValidacion Bean with the criteria values to
	 *            filter by.
	 * @param startsWith
	 *            Boolean
	 * @return Map created with two keys key query stores the sql query syntax
	 *         key params stores the parameter values to be used in the
	 *         condition sentence.
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de XXXX
	private Map<String, Object> getWhereLikeMap(
			Ab18aResultadoValidacion resultadoValidacion, Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				Ab18aResultadoValidacionDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (resultadoValidacion != null
				&& resultadoValidacion.getT09IdValidacion() != null) {
			where.append(" AND t1.T09_ID_VALIDACION = ?");
			params.add(resultadoValidacion.getT09IdValidacion());
		}
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01IdPeticionEnvio() !=
		// null) {
		// where.append(" AND t2.T01_ID_PETICION_ENVIO = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01IdPeticionEnvio());
		// }
		// if (resultadoValidacion != null
		// && resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a06s00() != null
		// &&
		// resultadoValidacion.getAb18a01s00().getAb18a06s00().getT06IdBoletin()
		// !=
		// null) {
		// where.append(" AND t2.T06_ID_BOLETIN = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getAb18a06s00()
		// .getT06IdBoletin());
		// }
		// if (resultadoValidacion != null
		// && resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a02s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a02s00()
		// .getT02IdTipoEnvio() != null) {
		// where.append(" AND t2.T02_ID_TIPO_ENVIO = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getAb18a02s00()
		// .getT02IdTipoEnvio());
		// }
		// if (resultadoValidacion != null
		// && resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a07s00() != null
		// &&
		// resultadoValidacion.getAb18a01s00().getAb18a07s00().getT07IdTicket()
		// !=
		// null) {
		// where.append(" AND t2.T07_ID_TICKET = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getAb18a07s00()
		// .getT07IdTicket());
		// }
		// if (resultadoValidacion != null
		// && resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a03s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a03s00()
		// .getT03IdAplicacion() != null) {
		// where.append(" AND t2.T03_ID_APLICACION = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getAb18a03s00()
		// .getT03IdAplicacion());
		// }
		// if (resultadoValidacion != null
		// && resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a11s00() != null
		// &&
		// resultadoValidacion.getAb18a01s00().getAb18a11s00().getT11IdEstado()
		// !=
		// null) {
		// where.append(" AND t2.T11_ID_ESTADO = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getAb18a11s00()
		// .getT11IdEstado());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01FechaAlta() != null) {
		// where.append(" AND t2.T01_FECHA_ALTA = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01FechaAlta());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01IdPoder() != null) {
		// where.append(" AND t2.T01_ID_PODER = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01IdPoder());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01IdEntidadImp() != null)
		// {
		// where.append(" AND t2.T01_ID_ENTIDAD_IMP = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01IdEntidadImp());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01IdOrgano() != null) {
		// where.append(" AND t2.T01_ID_ORGANO = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01IdOrgano());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01IdEntidadTram() != null)
		// {
		// where.append(" AND t2.T01_ID_ENTIDAD_TRAM = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01IdEntidadTram());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01IdMesa() != null) {
		// where.append(" AND t2.T01_ID_MESA = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01IdMesa());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01FechaProgrEnvio() !=
		// null) {
		// where.append(" AND t2.T01_FECHA_PROGR_ENVIO = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01FechaProgrEnvio());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01NumIntentos() != null) {
		// where.append(" AND t2.T01_NUM_INTENTOS = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getT01NumIntentos());
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01DatosError() != null) {
		// where.append(" AND UPPER(t2.T01_DATOS_ERROR) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(resultadoValidacion.getAb18a01s00().getT01DatosError()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + resultadoValidacion.getAb18a01s00().getT01DatosError()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t2.T01_DATOS_ERROR IS NOT NULL");
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01EstadoTram() != null) {
		// where.append(" AND UPPER(t2.T01_ESTADO_TRAM) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(resultadoValidacion.getAb18a01s00().getT01EstadoTram()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + resultadoValidacion.getAb18a01s00().getT01EstadoTram()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t2.T01_ESTADO_TRAM IS NOT NULL");
		// }
		// if (resultadoValidacion != null &&
		// resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getT01CodExpediente() != null)
		// {
		// where.append(" AND UPPER(t2.T01_COD_EXPEDIENTE) like ? ESCAPE  '\\'");
		// if (startsWith) {
		// params.add(resultadoValidacion.getAb18a01s00().getT01CodExpediente()
		// .toUpperCase()
		// + "%");
		// } else {
		// params.add("%"
		// + resultadoValidacion.getAb18a01s00().getT01CodExpediente()
		// .toUpperCase() + "%");
		// }
		// where.append(" AND t2.T01_COD_EXPEDIENTE IS NOT NULL");
		// }
		// if (resultadoValidacion != null
		// && resultadoValidacion.getAb18a01s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a14s00() != null
		// && resultadoValidacion.getAb18a01s00().getAb18a14s00()
		// .getT01IdPeticionEnvio() != null) {
		// where.append(" AND t2.T01_ID_PETICION_ENVIO = ?");
		// params.add(resultadoValidacion.getAb18a01s00().getAb18a14s00()
		// .getT01IdPeticionEnvio());
		// }
		if (resultadoValidacion != null
				&& resultadoValidacion.getT10IdTipoValidacion() != null) {
			where.append(" AND t1.T10_ID_TIPO_VALIDACION = ?");
			params.add(resultadoValidacion.getT10IdTipoValidacion());
		}
		if (resultadoValidacion != null
				&& resultadoValidacion.getT09NombreValid() != null) {
			where.append(" AND UPPER(t1.T09_NOMBRE_VALID) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(resultadoValidacion.getT09NombreValid()
						.toUpperCase() + "%");
			} else {
				params.add("%"
						+ resultadoValidacion.getT09NombreValid().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T09_NOMBRE_VALID IS NOT NULL");
		}
		if (resultadoValidacion != null
				&& resultadoValidacion.getT09Supera() != null) {
			where.append(" AND UPPER(t1.T09_SUPERA) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(resultadoValidacion.getT09Supera().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ resultadoValidacion.getT09Supera().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T09_SUPERA IS NOT NULL");
		}
		if (resultadoValidacion != null
				&& resultadoValidacion.getT09Severidad() != null) {
			where.append(" AND UPPER(t1.T09_SEVERIDAD) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(resultadoValidacion.getT09Severidad().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ resultadoValidacion.getT09Severidad().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T09_SEVERIDAD IS NOT NULL");
		}
		if (resultadoValidacion != null
				&& resultadoValidacion.getT09Mensaje() != null) {
			where.append(" AND UPPER(t1.T09_MENSAJE) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(resultadoValidacion.getT09Mensaje().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ resultadoValidacion.getT09Mensaje().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T09_MENSAJE IS NOT NULL");
		}
		if (resultadoValidacion != null
				&& resultadoValidacion.getT09Detalles() != null) {
			where.append(" AND UPPER(t1.T09_DETALLES) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(resultadoValidacion.getT09Detalles().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ resultadoValidacion.getT09Detalles().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.T09_DETALLES IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}

	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de XXXX

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
